/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.VWCachedSecurityList;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWParticipantListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.security.IVWUsersAndGroupsPanel;
import java.awt.Container;
import java.awt.Cursor;
import java.util.Vector;

public class VWUsersAndGroupsPanel
extends VWAddRemovePanel
implements IVWUsersAndGroupsPanel {
    protected VWParticipantItem[] m_availableParticipants = null;
    protected boolean m_bIncludeGroups = true;

    public VWUsersAndGroupsPanel() {
        super(138);
        this.enableSorting(1536);
        this.m_bIncludeGroups = true;
        this.setAvailableItemName(VWResource.s_availableUsers);
        this.setSelectedItemName(VWResource.s_selectedUsers);
    }

    public VWUsersAndGroupsPanel(Container parentContainer, VWSession vwSession) {
        super(138, parentContainer, vwSession);
        this.enableSorting(1536);
        this.m_bIncludeGroups = true;
        this.setAvailableItemName(VWResource.s_availableUsers);
        this.setSelectedItemName(VWResource.s_selectedUsers);
    }

    public VWUsersAndGroupsPanel(VWSession vwSession, boolean bIncludeGroups) {
        super(138);
        this.enableSorting(1536);
        this.m_vwSession = vwSession;
        this.m_bIncludeGroups = bIncludeGroups;
        this.setAvailableItemName(VWResource.s_availableUsers);
        this.setSelectedItemName(VWResource.s_selectedUsers);
        this.initializeLists(null);
    }

    public VWUsersAndGroupsPanel(VWSession vwSession) {
        this(vwSession, true);
    }

    public void init(VWParticipantItem[] selectedParticipants) {
        try {
            this.initializeParticipantsLists(selectedParticipants);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWParticipantItem[] getParticipants() {
        VWParticipantItem[] vwParticipants = null;
        try {
            Object[] selectedItems = this.getSelectedItems();
            if (selectedItems != null && selectedItems.length > 0) {
                vwParticipants = new VWParticipantItem[selectedItems.length];
                for (int nIndex = 0; nIndex < selectedItems.length; ++nIndex) {
                    vwParticipants[nIndex] = (VWParticipantItem)selectedItems[nIndex];
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return vwParticipants;
    }

    public void removeReferences() {
        if (this.m_availableParticipants != null) {
            for (int i = 0; i < this.m_availableParticipants.length; ++i) {
                this.m_availableParticipants[i] = null;
            }
            this.m_availableParticipants = null;
        }
        super.removeReferences();
    }

    public void releaseResources() {
        this.removeReferences();
    }

    protected void initializeParticipantsLists(Object[] selectedNames) {
        try {
            this.setListCellRenderer(new VWParticipantListCellRenderer());
            super.initializeLists(this.m_availableParticipants, selectedNames);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void initializeLists(String[] selectedNames) {
        Cursor currentCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.retrieveUsersAndGroups();
            this.setListCellRenderer(new VWParticipantListCellRenderer());
            super.initializeLists(this.m_availableParticipants, selectedNames);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.setCursor(currentCursor);
    }

    protected void retrieveUsersAndGroups() {
        try {
            if (this.m_vwSession == null) {
                return;
            }
            if (this.m_availableParticipants == null) {
                this.m_availableParticipants = this.m_bIncludeGroups ? VWCachedSecurityList.getUsersAndGroupsParticipant(this.m_vwSession) : VWCachedSecurityList.getUsersParticipant(this.m_vwSession);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected String getFormattedName(String participantName) {
        return participantName;
    }

    protected Object[] onRemoveItemsAction(Object[] items) {
        Vector<Object> returnSet = null;
        try {
            returnSet = new Vector<Object>();
            for (int i = 0; i < items.length; ++i) {
                if (!(items[i] instanceof VWParticipantItem)) continue;
                returnSet.add(items[i]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return returnSet.toArray();
    }

    protected VWParticipantItem getParticipantItem(String userName, String[] groupNames) {
        try {
            if (groupNames != null && groupNames.length > 0) {
                for (int i = 0; i < groupNames.length; ++i) {
                    if (VWStringUtils.compare(userName, groupNames[i]) != 0) continue;
                    return new VWParticipantItem(userName, 1);
                }
            }
            return new VWParticipantItem(userName, 0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

